package tests;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;

import javax.swing.JFrame;
import javax.swing.JPanel;

import model.Catalogo;
import model.IPezzo;
import model.Pezzo;
import model.ProxyPezzo;
import view.FilterExpPanel;
import view.LogPanel;
import view.PezzoPanel;

public class Test3 {

	private static JFrame frame;

	public static Frame getFrame() {
		// TODO Auto-generated method stub
		return frame;
	}

	public static void main(String[] args) {

		Test3.frame = new JFrame();
		frame.setTitle("Test3");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(800, 300);

		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
		frame.setLocation((int) (dim.getWidth() - frame.getWidth()) / 2,
				(int) (dim.getHeight() - frame.getHeight()) / 2);

		JPanel panel = new JPanel();
		frame.getContentPane().add(panel);
		panel.setLayout(new GridLayout(3, 1));

		IPezzo pezzo = new Pezzo();
		ProxyPezzo realpezzo = new ProxyPezzo(pezzo);
		Catalogo catalogo = new Catalogo();

		PezzoPanel pezzopane = new PezzoPanel(catalogo);
		LogPanel logpane = new LogPanel(catalogo);
		FilterExpPanel filterpane = new FilterExpPanel(catalogo);

		frame.setVisible(true);
		panel.add(pezzopane);
		panel.add(logpane);
		panel.add(filterpane);

	}
}
